/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.boat.api.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ChestRaftModel;
import net.minecraft.client.model.RaftModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceLocation;

@Environment(value=EnvType.CLIENT)
public final class TerraformBoatClientHelper {
    private TerraformBoatClientHelper() {
    }

    private static ResourceLocation getLayerId(ResourceLocation boatId, boolean raft, boolean chest) {
        String prefix = raft ? (chest ? "chest_raft/" : "raft/") : (chest ? "chest_boat/" : "boat/");
        return new ResourceLocation(boatId.m_135827_(), prefix + boatId.m_135815_());
    }

    public static ModelLayerLocation getLayer(ResourceLocation boatId, boolean raft, boolean chest) {
        return new ModelLayerLocation(TerraformBoatClientHelper.getLayerId(boatId, raft, chest), "main");
    }

    private static EntityModelLayerRegistry.TexturedModelDataProvider getTexturedModelDataProvider(boolean raft, boolean chest) {
        if (raft) {
            return chest ? ChestRaftModel::m_246875_ : RaftModel::m_247376_;
        }
        return chest ? ChestBoatModel::m_247175_ : BoatModel::m_246613_;
    }

    private static void registerModelLayer(ResourceLocation boatId, boolean raft, boolean chest) {
        EntityModelLayerRegistry.registerModelLayer((ModelLayerLocation)TerraformBoatClientHelper.getLayer(boatId, raft, chest), (EntityModelLayerRegistry.TexturedModelDataProvider)TerraformBoatClientHelper.getTexturedModelDataProvider(raft, chest));
    }

    public static void registerModelLayers(ResourceLocation boatId, boolean raft) {
        TerraformBoatClientHelper.registerModelLayer(boatId, raft, false);
        TerraformBoatClientHelper.registerModelLayer(boatId, raft, true);
    }
}

